/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.text.folding;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.asnlab.asndt.internal.corext.util.Messages;
import org.asnlab.asndt.internal.ui.AsnPlugin;
import org.asnlab.asndt.internal.ui.text.folding.AsnFoldingStructureProviderDescriptor;
import org.asnlab.asndt.internal.ui.text.folding.FoldingMessages;
import org.asnlab.asndt.ui.text.folding.IAsnFoldingStructureProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;

public class AsnFoldingStructureProviderRegistry {
    private static final String EXTENSION_POINT = "foldingStructureProviders";
    private Map fDescriptors;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsnFoldingStructureProviderDescriptor[] getFoldingProviderDescriptors() {
        AsnFoldingStructureProviderRegistry asnFoldingStructureProviderRegistry = this;
        synchronized (asnFoldingStructureProviderRegistry) {
            this.ensureRegistered();
            return this.fDescriptors.values().toArray(new AsnFoldingStructureProviderDescriptor[this.fDescriptors.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsnFoldingStructureProviderDescriptor getFoldingProviderDescriptor(String id) {
        AsnFoldingStructureProviderRegistry asnFoldingStructureProviderRegistry = this;
        synchronized (asnFoldingStructureProviderRegistry) {
            this.ensureRegistered();
            return (AsnFoldingStructureProviderDescriptor)this.fDescriptors.get(id);
        }
    }

    public IAsnFoldingStructureProvider getCurrentFoldingProvider() {
        IPreferenceStore preferenceStore = AsnPlugin.getDefault().getPreferenceStore();
        String currentProviderId = preferenceStore.getString("editor_folding_provider");
        AsnFoldingStructureProviderDescriptor desc = this.getFoldingProviderDescriptor(currentProviderId);
        if (desc == null) {
            String message = Messages.format(FoldingMessages.AsnFoldingStructureProviderRegistry_warning_providerNotFound_resetToDefault, currentProviderId);
            AsnPlugin.log((IStatus)new Status(2, AsnPlugin.getPluginId(), 0, message, null));
            String defaultProviderId = preferenceStore.getDefaultString("editor_folding_provider");
            desc = this.getFoldingProviderDescriptor(defaultProviderId);
            if (desc == null) {
                return null;
            }
            preferenceStore.setToDefault("editor_folding_provider");
        }
        try {
            return desc.createProvider();
        }
        catch (CoreException e) {
            AsnPlugin.log(e);
            return null;
        }
    }

    private void ensureRegistered() {
        if (this.fDescriptors == null) {
            this.reloadExtensions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        HashMap<String, AsnFoldingStructureProviderDescriptor> map = new HashMap<String, AsnFoldingStructureProviderDescriptor>();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(AsnPlugin.getPluginId(), EXTENSION_POINT);
        int i = 0;
        while (i < elements.length) {
            AsnFoldingStructureProviderDescriptor desc = new AsnFoldingStructureProviderDescriptor(elements[i]);
            map.put(desc.getId(), desc);
            ++i;
        }
        AsnFoldingStructureProviderRegistry asnFoldingStructureProviderRegistry = this;
        synchronized (asnFoldingStructureProviderRegistry) {
            this.fDescriptors = Collections.unmodifiableMap(map);
        }
    }
}

