/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.preferences;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.asnlab.asndt.internal.ui.AsnPlugin;
import org.asnlab.asndt.internal.ui.asneditor.AsnSourceViewer;
import org.asnlab.asndt.internal.ui.asneditor.SemanticHighlighting;
import org.asnlab.asndt.internal.ui.asneditor.SemanticHighlightingManager;
import org.asnlab.asndt.internal.ui.asneditor.SemanticHighlightings;
import org.asnlab.asndt.internal.ui.preferences.AbstractConfigurationBlock;
import org.asnlab.asndt.internal.ui.preferences.AsnSourcePreviewerUpdater;
import org.asnlab.asndt.internal.ui.preferences.OverlayPreferenceStore;
import org.asnlab.asndt.internal.ui.preferences.PreferencesMessages;
import org.asnlab.asndt.internal.ui.text.AsnColorManager;
import org.asnlab.asndt.internal.ui.text.PreferencesAdapter;
import org.asnlab.asndt.internal.ui.text.SimpleAsnSourceViewerConfiguration;
import org.asnlab.asndt.internal.ui.util.PixelConverter;
import org.asnlab.asndt.ui.text.IColorManager;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;

class AsnEditorColoringConfigurationBlock
extends AbstractConfigurationBlock {
    private static final String BOLD = "_bold";
    private static final String ITALIC = "_italic";
    private static final String STRIKETHROUGH = "_strikethrough";
    private static final String UNDERLINE = "_underline";
    private final String[][] fSyntaxColorListModel = new String[][]{{PreferencesMessages.AsnEditorPreferencePage_multiLineComment, "asn_multi_line_comment"}, {PreferencesMessages.AsnEditorPreferencePage_singleLineComment, "asn_single_line_comment"}, {PreferencesMessages.AsnEditorPreferencePage_built_in_type_keywords, "asn_built_in_type_keyword"}, {PreferencesMessages.AsnEditorPreferencePage_tagging_keywords, "asn_tagging_keyword"}, {PreferencesMessages.AsnEditorPreferencePage_constraint_keywords, "asn_constraint_keyword"}, {PreferencesMessages.AsnEditorPreferencePage_Optionality, "asn_optionality"}, {PreferencesMessages.AsnEditorPreferencePage_keywords, "asn_keyword"}, {PreferencesMessages.AsnEditorPreferencePage_strings, "asn_string"}, {PreferencesMessages.AsnEditorPreferencePage_others, "asn_default"}};
    private final String fAsnCategory = PreferencesMessages.AsnEditorPreferencePage_coloring_category_asn;
    private final String fCommentsCategory = PreferencesMessages.AsnEditorPreferencePage_coloring_category_comments;
    private ColorSelector fSyntaxForegroundColorEditor;
    private Label fColorEditorLabel;
    private Button fEnableCheckbox;
    private Button fBoldCheckBox;
    private Button fItalicCheckBox;
    private Button fStrikethroughCheckBox;
    private Button fUnderlineCheckBox;
    private final List fListModel = new ArrayList();
    private StructuredViewer fListViewer;
    private SemanticHighlightingManager fSemanticHighlightingManager;
    private AsnSourceViewer fPreviewViewer;
    private IColorManager fColorManager = new AsnColorManager(false);
    private FontMetrics fFontMetrics;

    public AsnEditorColoringConfigurationBlock(OverlayPreferenceStore store) {
        super(store);
        int i = 0;
        int n = this.fSyntaxColorListModel.length;
        while (i < n) {
            this.fListModel.add(new HighlightingColorListItem(this.fSyntaxColorListModel[i][0], this.fSyntaxColorListModel[i][1], String.valueOf(this.fSyntaxColorListModel[i][1]) + BOLD, String.valueOf(this.fSyntaxColorListModel[i][1]) + ITALIC, String.valueOf(this.fSyntaxColorListModel[i][1]) + STRIKETHROUGH, String.valueOf(this.fSyntaxColorListModel[i][1]) + UNDERLINE));
            ++i;
        }
        SemanticHighlighting[] semanticHighlightings = SemanticHighlightings.getSemanticHighlightings();
        int i2 = 0;
        int n2 = semanticHighlightings.length;
        while (i2 < n2) {
            this.fListModel.add(new SemanticHighlightingColorListItem(semanticHighlightings[i2].getDisplayName(), SemanticHighlightings.getColorPreferenceKey(semanticHighlightings[i2]), SemanticHighlightings.getBoldPreferenceKey(semanticHighlightings[i2]), SemanticHighlightings.getItalicPreferenceKey(semanticHighlightings[i2]), SemanticHighlightings.getStrikethroughPreferenceKey(semanticHighlightings[i2]), SemanticHighlightings.getUnderlinePreferenceKey(semanticHighlightings[i2]), SemanticHighlightings.getEnabledPreferenceKey(semanticHighlightings[i2])));
            ++i2;
        }
        store.addKeys(this.createOverlayStoreKeys());
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        int i = 0;
        int n = this.fListModel.size();
        while (i < n) {
            HighlightingColorListItem item = (HighlightingColorListItem)this.fListModel.get(i);
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, item.getColorKey()));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, item.getBoldKey()));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, item.getItalicKey()));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, item.getStrikethroughKey()));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, item.getUnderlineKey()));
            if (item instanceof SemanticHighlightingColorListItem) {
                overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, ((SemanticHighlightingColorListItem)item).getEnableKey()));
            }
            ++i;
        }
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return keys;
    }

    public Control createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        return this.createSyntaxPage(parent);
    }

    private int convertWidthInCharsToPixels(int chars) {
        if (this.fFontMetrics == null) {
            return 0;
        }
        return Dialog.convertWidthInCharsToPixels((FontMetrics)this.fFontMetrics, (int)chars);
    }

    private int convertHeightInCharsToPixels(int chars) {
        if (this.fFontMetrics == null) {
            return 0;
        }
        return Dialog.convertHeightInCharsToPixels((FontMetrics)this.fFontMetrics, (int)chars);
    }

    public void initialize() {
        super.initialize();
        this.fListViewer.setInput((Object)this.fListModel);
        this.fListViewer.setSelection((ISelection)new StructuredSelection((Object)this.fAsnCategory));
    }

    public void performDefaults() {
        super.performDefaults();
        this.handleSyntaxColorListSelection();
        this.uninstallSemanticHighlighting();
        this.installSemanticHighlighting();
        this.fPreviewViewer.invalidateTextPresentation();
    }

    public void dispose() {
        this.uninstallSemanticHighlighting();
        this.fColorManager.dispose();
        super.dispose();
    }

    private void handleSyntaxColorListSelection() {
        HighlightingColorListItem item = this.getHighlightingColorListItem();
        if (item == null) {
            this.fEnableCheckbox.setEnabled(false);
            this.fSyntaxForegroundColorEditor.getButton().setEnabled(false);
            this.fColorEditorLabel.setEnabled(false);
            this.fBoldCheckBox.setEnabled(false);
            this.fItalicCheckBox.setEnabled(false);
            this.fStrikethroughCheckBox.setEnabled(false);
            this.fUnderlineCheckBox.setEnabled(false);
            return;
        }
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)item.getColorKey());
        this.fSyntaxForegroundColorEditor.setColorValue(rgb);
        this.fBoldCheckBox.setSelection(this.getPreferenceStore().getBoolean(item.getBoldKey()));
        this.fItalicCheckBox.setSelection(this.getPreferenceStore().getBoolean(item.getItalicKey()));
        this.fStrikethroughCheckBox.setSelection(this.getPreferenceStore().getBoolean(item.getStrikethroughKey()));
        this.fUnderlineCheckBox.setSelection(this.getPreferenceStore().getBoolean(item.getUnderlineKey()));
        if (item instanceof SemanticHighlightingColorListItem) {
            this.fEnableCheckbox.setEnabled(true);
            boolean enable = this.getPreferenceStore().getBoolean(((SemanticHighlightingColorListItem)item).getEnableKey());
            this.fEnableCheckbox.setSelection(enable);
            this.fSyntaxForegroundColorEditor.getButton().setEnabled(enable);
            this.fColorEditorLabel.setEnabled(enable);
            this.fBoldCheckBox.setEnabled(enable);
            this.fItalicCheckBox.setEnabled(enable);
            this.fStrikethroughCheckBox.setEnabled(enable);
            this.fUnderlineCheckBox.setEnabled(enable);
        } else {
            this.fSyntaxForegroundColorEditor.getButton().setEnabled(true);
            this.fColorEditorLabel.setEnabled(true);
            this.fBoldCheckBox.setEnabled(true);
            this.fItalicCheckBox.setEnabled(true);
            this.fStrikethroughCheckBox.setEnabled(true);
            this.fUnderlineCheckBox.setEnabled(true);
            this.fEnableCheckbox.setEnabled(false);
            this.fEnableCheckbox.setSelection(true);
        }
    }

    private Control createSyntaxPage(final Composite parent) {
        Composite colorComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        colorComposite.setLayout((Layout)layout);
        Link link = new Link(colorComposite, 0);
        link.setText(PreferencesMessages.AsnEditorColoringConfigurationBlock_link);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)parent.getShell(), (String)e.text, null, null);
            }
        });
        GridData gridData = new GridData(4, 1, true, false);
        gridData.widthHint = 150;
        gridData.horizontalSpan = 2;
        link.setLayoutData((Object)gridData);
        this.addFiller(colorComposite, 1);
        Label label = new Label(colorComposite, 16384);
        label.setText(PreferencesMessages.AsnEditorPreferencePage_coloring_element);
        label.setLayoutData((Object)new GridData(768));
        Composite editorComposite = new Composite(colorComposite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        GridData gd = new GridData(4, 1, true, false);
        editorComposite.setLayoutData((Object)gd);
        this.fListViewer = new TreeViewer(editorComposite, 2052);
        this.fListViewer.setLabelProvider((IBaseLabelProvider)new ColorListLabelProvider());
        this.fListViewer.setContentProvider((IContentProvider)new ColorListContentProvider());
        this.fListViewer.setSorter(new ViewerSorter(){

            public int category(Object element) {
                if (AsnEditorColoringConfigurationBlock.this.fCommentsCategory.equals(element)) {
                    return 0;
                }
                if (AsnEditorColoringConfigurationBlock.this.fAsnCategory.equals(element)) {
                    return 1;
                }
                return 0;
            }
        });
        gd = new GridData(1, 1, false, true);
        gd.heightHint = this.convertHeightInCharsToPixels(9);
        int maxWidth = 0;
        for (HighlightingColorListItem item : this.fListModel) {
            maxWidth = Math.max(maxWidth, this.convertWidthInCharsToPixels(item.getDisplayName().length()));
        }
        ScrollBar vBar = ((Scrollable)this.fListViewer.getControl()).getVerticalBar();
        if (vBar != null) {
            maxWidth += vBar.getSize().x * 3;
        }
        gd.widthHint = maxWidth;
        this.fListViewer.getControl().setLayoutData((Object)gd);
        Composite stylesComposite = new Composite(editorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        stylesComposite.setLayout((Layout)layout);
        stylesComposite.setLayoutData((Object)new GridData(1808));
        this.fEnableCheckbox = new Button(stylesComposite, 32);
        this.fEnableCheckbox.setText(PreferencesMessages.AsnEditorPreferencePage_enable);
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fEnableCheckbox.setLayoutData((Object)gd);
        this.fColorEditorLabel = new Label(stylesComposite, 16384);
        this.fColorEditorLabel.setText(PreferencesMessages.AsnEditorPreferencePage_color);
        gd = new GridData(32);
        gd.horizontalIndent = 20;
        this.fColorEditorLabel.setLayoutData((Object)gd);
        this.fSyntaxForegroundColorEditor = new ColorSelector(stylesComposite);
        Button foregroundColorButton = this.fSyntaxForegroundColorEditor.getButton();
        gd = new GridData(32);
        foregroundColorButton.setLayoutData((Object)gd);
        this.fBoldCheckBox = new Button(stylesComposite, 32);
        this.fBoldCheckBox.setText(PreferencesMessages.AsnEditorPreferencePage_bold);
        gd = new GridData(32);
        gd.horizontalIndent = 20;
        gd.horizontalSpan = 2;
        this.fBoldCheckBox.setLayoutData((Object)gd);
        this.fItalicCheckBox = new Button(stylesComposite, 32);
        this.fItalicCheckBox.setText(PreferencesMessages.AsnEditorPreferencePage_italic);
        gd = new GridData(32);
        gd.horizontalIndent = 20;
        gd.horizontalSpan = 2;
        this.fItalicCheckBox.setLayoutData((Object)gd);
        this.fStrikethroughCheckBox = new Button(stylesComposite, 32);
        this.fStrikethroughCheckBox.setText(PreferencesMessages.AsnEditorPreferencePage_strikethrough);
        gd = new GridData(32);
        gd.horizontalIndent = 20;
        gd.horizontalSpan = 2;
        this.fStrikethroughCheckBox.setLayoutData((Object)gd);
        this.fUnderlineCheckBox = new Button(stylesComposite, 32);
        this.fUnderlineCheckBox.setText(PreferencesMessages.AsnEditorPreferencePage_underline);
        gd = new GridData(32);
        gd.horizontalIndent = 20;
        gd.horizontalSpan = 2;
        this.fUnderlineCheckBox.setLayoutData((Object)gd);
        label = new Label(colorComposite, 16384);
        label.setText(PreferencesMessages.AsnEditorPreferencePage_preview);
        label.setLayoutData((Object)new GridData(768));
        Control previewer = this.createPreviewer(colorComposite);
        gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(20);
        gd.heightHint = this.convertHeightInCharsToPixels(5);
        previewer.setLayoutData((Object)gd);
        this.fListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AsnEditorColoringConfigurationBlock.this.handleSyntaxColorListSelection();
            }
        });
        foregroundColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = AsnEditorColoringConfigurationBlock.this.getHighlightingColorListItem();
                PreferenceConverter.setValue((IPreferenceStore)AsnEditorColoringConfigurationBlock.this.getPreferenceStore(), (String)item.getColorKey(), (RGB)AsnEditorColoringConfigurationBlock.this.fSyntaxForegroundColorEditor.getColorValue());
            }
        });
        this.fBoldCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = AsnEditorColoringConfigurationBlock.this.getHighlightingColorListItem();
                AsnEditorColoringConfigurationBlock.this.getPreferenceStore().setValue(item.getBoldKey(), AsnEditorColoringConfigurationBlock.this.fBoldCheckBox.getSelection());
            }
        });
        this.fItalicCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = AsnEditorColoringConfigurationBlock.this.getHighlightingColorListItem();
                AsnEditorColoringConfigurationBlock.this.getPreferenceStore().setValue(item.getItalicKey(), AsnEditorColoringConfigurationBlock.this.fItalicCheckBox.getSelection());
            }
        });
        this.fStrikethroughCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = AsnEditorColoringConfigurationBlock.this.getHighlightingColorListItem();
                AsnEditorColoringConfigurationBlock.this.getPreferenceStore().setValue(item.getStrikethroughKey(), AsnEditorColoringConfigurationBlock.this.fStrikethroughCheckBox.getSelection());
            }
        });
        this.fUnderlineCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = AsnEditorColoringConfigurationBlock.this.getHighlightingColorListItem();
                AsnEditorColoringConfigurationBlock.this.getPreferenceStore().setValue(item.getUnderlineKey(), AsnEditorColoringConfigurationBlock.this.fUnderlineCheckBox.getSelection());
            }
        });
        this.fEnableCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = AsnEditorColoringConfigurationBlock.this.getHighlightingColorListItem();
                if (item instanceof SemanticHighlightingColorListItem) {
                    boolean enable = AsnEditorColoringConfigurationBlock.this.fEnableCheckbox.getSelection();
                    AsnEditorColoringConfigurationBlock.this.getPreferenceStore().setValue(((SemanticHighlightingColorListItem)item).getEnableKey(), enable);
                    AsnEditorColoringConfigurationBlock.this.fEnableCheckbox.setSelection(enable);
                    AsnEditorColoringConfigurationBlock.this.fSyntaxForegroundColorEditor.getButton().setEnabled(enable);
                    AsnEditorColoringConfigurationBlock.this.fColorEditorLabel.setEnabled(enable);
                    AsnEditorColoringConfigurationBlock.this.fBoldCheckBox.setEnabled(enable);
                    AsnEditorColoringConfigurationBlock.this.fItalicCheckBox.setEnabled(enable);
                    AsnEditorColoringConfigurationBlock.this.fStrikethroughCheckBox.setEnabled(enable);
                    AsnEditorColoringConfigurationBlock.this.fUnderlineCheckBox.setEnabled(enable);
                    AsnEditorColoringConfigurationBlock.this.uninstallSemanticHighlighting();
                    AsnEditorColoringConfigurationBlock.this.installSemanticHighlighting();
                }
            }
        });
        colorComposite.layout(false);
        return colorComposite;
    }

    private void addFiller(Composite composite, int horizontalSpan) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Label filler = new Label(composite, 16384);
        GridData gd = new GridData(256);
        gd.horizontalSpan = horizontalSpan;
        gd.heightHint = pixelConverter.convertHeightInCharsToPixels(1) / 2;
        filler.setLayoutData((Object)gd);
    }

    private Control createPreviewer(Composite parent) {
        IPreferenceStore generalTextStore = EditorsUI.getPreferenceStore();
        ChainedPreferenceStore store = new ChainedPreferenceStore(new IPreferenceStore[]{this.getPreferenceStore(), new PreferencesAdapter(this.createTemporaryCorePreferenceStore()), generalTextStore});
        this.fPreviewViewer = new AsnSourceViewer(parent, null, null, false, 2816, (IPreferenceStore)store);
        SimpleAsnSourceViewerConfiguration configuration = new SimpleAsnSourceViewerConfiguration(this.fColorManager, (IPreferenceStore)store, null, "___asn_partitioning", false);
        this.fPreviewViewer.configure((SourceViewerConfiguration)configuration);
        Font font = JFaceResources.getFont((String)"org.asnlab.asndt.ui.editors.textfont");
        this.fPreviewViewer.getTextWidget().setFont(font);
        new AsnSourcePreviewerUpdater((SourceViewer)this.fPreviewViewer, configuration, (IPreferenceStore)store);
        this.fPreviewViewer.setEditable(false);
        String content = this.loadPreviewContentFromFile("ColorSettingPreviewCode.txt");
        Document document = new Document(content);
        AsnPlugin.getDefault().getAsnTextTools().setupAsnDocumentPartitioner((IDocument)document, "___asn_partitioning");
        this.fPreviewViewer.setDocument((IDocument)document);
        this.installSemanticHighlighting();
        return this.fPreviewViewer.getControl();
    }

    private Preferences createTemporaryCorePreferenceStore() {
        return new Preferences();
    }

    private String loadPreviewContentFromFile(String filename) {
        StringBuffer buffer;
        block15: {
            String separator = System.getProperty("line.separator");
            buffer = new StringBuffer(512);
            BufferedReader reader = null;
            try {
                try {
                    String line;
                    reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(filename)));
                    while ((line = reader.readLine()) != null) {
                        buffer.append(line);
                        buffer.append(separator);
                    }
                }
                catch (IOException io) {
                    AsnPlugin.log(io);
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return buffer.toString();
    }

    private void installSemanticHighlighting() {
        if (this.fSemanticHighlightingManager == null) {
            this.fSemanticHighlightingManager = new SemanticHighlightingManager();
            this.fSemanticHighlightingManager.install(this.fPreviewViewer, this.fColorManager, this.getPreferenceStore(), this.createPreviewerRanges());
        }
    }

    private void uninstallSemanticHighlighting() {
        if (this.fSemanticHighlightingManager != null) {
            this.fSemanticHighlightingManager.uninstall();
            this.fSemanticHighlightingManager = null;
        }
    }

    private SemanticHighlightingManager.HighlightedRange[][] createPreviewerRanges() {
        return new SemanticHighlightingManager.HighlightedRange[][]{{this.createHighlightedRange(5, 0, 8, "module")}, {this.createHighlightedRange(10, 8, 6, "type")}, {this.createHighlightedRange(10, 16, 7, "value")}, {this.createHighlightedRange(11, 8, 9, "type")}, {this.createHighlightedRange(12, 8, 10, "value")}, {this.createHighlightedRange(13, 8, 11, "module")}, {this.createHighlightedRange(16, 4, 6, "type")}, {this.createHighlightedRange(18, 4, 6, "type")}, {this.createHighlightedRange(19, 8, 4, "component")}, {this.createHighlightedRange(20, 8, 5, "component")}, {this.createHighlightedRange(25, 8, 4, "component")}, {this.createHighlightedRange(21, 33, 3, "value")}, {this.createHighlightedRange(22, 33, 5, "value")}, {this.createHighlightedRange(23, 33, 4, "value")}, {this.createHighlightedRange(25, 29, 9, "type")}, {this.createHighlightedRange(25, 47, 10, "value")}, {this.createHighlightedRange(28, 4, 7, "value")}, {this.createHighlightedRange(28, 12, 6, "type")}, {this.createHighlightedRange(29, 8, 4, "component")}, {this.createHighlightedRange(30, 8, 5, "component")}, {this.createHighlightedRange(31, 8, 4, "component")}, {this.createHighlightedRange(30, 18, 5, "value")}, {this.createHighlightedRange(31, 18, 10, "value")}};
    }

    private SemanticHighlightingManager.HighlightedRange createHighlightedRange(int line, int column, int length, String key) {
        try {
            IDocument document = this.fPreviewViewer.getDocument();
            int offset = document.getLineOffset(line) + column;
            return new SemanticHighlightingManager.HighlightedRange(offset, length, key);
        }
        catch (BadLocationException x) {
            AsnPlugin.log(x);
            return null;
        }
    }

    private HighlightingColorListItem getHighlightingColorListItem() {
        IStructuredSelection selection = (IStructuredSelection)this.fListViewer.getSelection();
        Object element = selection.getFirstElement();
        if (element instanceof String) {
            return null;
        }
        return (HighlightingColorListItem)element;
    }

    private void initializeDialogUnits(Control testControl) {
        GC gc = new GC((Drawable)testControl);
        gc.setFont(JFaceResources.getDialogFont());
        this.fFontMetrics = gc.getFontMetrics();
        gc.dispose();
    }

    private class ColorListContentProvider
    implements ITreeContentProvider {
        private ColorListContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return new String[]{AsnEditorColoringConfigurationBlock.this.fCommentsCategory, AsnEditorColoringConfigurationBlock.this.fAsnCategory};
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof String) {
                String entry = (String)parentElement;
                if (AsnEditorColoringConfigurationBlock.this.fCommentsCategory.equals(entry)) {
                    return AsnEditorColoringConfigurationBlock.this.fListModel.subList(0, 2).toArray();
                }
                if (AsnEditorColoringConfigurationBlock.this.fAsnCategory.equals(entry)) {
                    return AsnEditorColoringConfigurationBlock.this.fListModel.subList(2, AsnEditorColoringConfigurationBlock.this.fListModel.size()).toArray();
                }
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof String) {
                return null;
            }
            int index = AsnEditorColoringConfigurationBlock.this.fListModel.indexOf(element);
            if (index >= 2) {
                return AsnEditorColoringConfigurationBlock.this.fAsnCategory;
            }
            return AsnEditorColoringConfigurationBlock.this.fCommentsCategory;
        }

        public boolean hasChildren(Object element) {
            return element instanceof String;
        }
    }

    private class ColorListLabelProvider
    extends LabelProvider {
        private ColorListLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof String) {
                return (String)element;
            }
            return ((HighlightingColorListItem)element).getDisplayName();
        }
    }

    private static class HighlightingColorListItem {
        private String fDisplayName;
        private String fColorKey;
        private String fBoldKey;
        private String fItalicKey;
        private String fStrikethroughKey;
        private String fUnderlineKey;

        public HighlightingColorListItem(String displayName, String colorKey, String boldKey, String italicKey, String strikethroughKey, String underlineKey) {
            this.fDisplayName = displayName;
            this.fColorKey = colorKey;
            this.fBoldKey = boldKey;
            this.fItalicKey = italicKey;
            this.fStrikethroughKey = strikethroughKey;
            this.fUnderlineKey = underlineKey;
        }

        public String getBoldKey() {
            return this.fBoldKey;
        }

        public String getItalicKey() {
            return this.fItalicKey;
        }

        public String getStrikethroughKey() {
            return this.fStrikethroughKey;
        }

        public String getUnderlineKey() {
            return this.fUnderlineKey;
        }

        public String getColorKey() {
            return this.fColorKey;
        }

        public String getDisplayName() {
            return this.fDisplayName;
        }
    }

    private static class SemanticHighlightingColorListItem
    extends HighlightingColorListItem {
        private final String fEnableKey;

        public SemanticHighlightingColorListItem(String displayName, String colorKey, String boldKey, String italicKey, String strikethroughKey, String underlineKey, String enableKey) {
            super(displayName, colorKey, boldKey, italicKey, strikethroughKey, underlineKey);
            this.fEnableKey = enableKey;
        }

        public String getEnableKey() {
            return this.fEnableKey;
        }
    }
}

